syms s t

Gp=1/(2*s+1);
Gm=1/(s+1);
Go=2/(2*s+1);
Gv=1/(3*s+1);

%P
Kc=0.5*10;
P=Kc;

%PI
Kc=0.45*10;
tI=(1/1.2)*6.283;
PI=Kc*(1+(1/(tI*s)));

%PID
Kc=0.6*10;
tI=0.5*6.283;
tD=0.125*6.283;
PID=Kc*(1+(1/(tI*s))+tD*s);

Ysp=24*heaviside(t)+10*t*heaviside(t)-10*(t-7.6)*heaviside(t-7.6)+20*(t-37.6)*heaviside(t-37.6)-20*(t-57.6)*heaviside(t-57.6)-20*(t-97.6)*heaviside(t-97.6)+20*(t-121.4)*heaviside(t-121.4);
ysp=laplace(Ysp);
To=24;

%P
Y1=(Gp*P*Gv*ysp)/(1+Gp*Gv*Gm*P)+(Go*To)/(1+Gp*Gv*Gm*P);
y1=ilaplace(Y1);
U1=(P*Gv*ysp)/(1+Gp*Gv*Gm*P)-(Go*Gv*Gm*P*To)/(1+Gp*Gv*Gm*P);
u1=ilaplace(U1);
E1=ysp-Y1;
e1=ilaplace(E1);

%PI
Y2=(Gp*PI*Gv*ysp)/(1+Gp*Gv*Gm*PI)+(Go*To)/(1+Gp*Gv*Gm*PI);
y2=ilaplace(Y2);
U2=(PI*Gv*ysp)/(1+Gp*Gv*Gm*PI)-(Go*Gv*Gm*PI*To)/(1+Gp*Gv*Gm*PI);
u2=ilaplace(U2);
E2=ysp-Y2;
e2=ilaplace(E2);

%PID
Y3=(Gp*PID*Gv*ysp)/(1+Gp*Gv*Gm*PID)+(Go*To)/(1+Gp*Gv*Gm*PID);
y3=ilaplace(Y3);
U3=(PID*Gv*ysp)/(1+Gp*Gv*Gm*PID)-(Go*Gv*Gm*PID*To)/(1+Gp*Gv*Gm*PID);
u3=ilaplace(U3);
E3=ysp-Y3;
e3=ilaplace(E3);

Total_Time=200;
t=0:1:Total_Time;

%P
y1=vpa(y1);
y1=subs(y1,t);
y1=double(y1);
u1=vpa(u1);
u1=subs(u1,t);
e1=vpa(e1);
e1=subs(e1,t);

%PI
y2=vpa(y2);
y2=subs(y2,t);
y2=double(y2);
u2=vpa(u2);
u2=subs(u2,t);
e2=vpa(e2);
e2=subs(e2,t);

%PID
y3=vpa(y3);
y3=subs(y3,t);
y3=double(y3);
u3=vpa(u3);
u3=subs(u3,t);
e3=vpa(e3);
e3=subs(e3,t);

ysp=ilaplace(ysp);
ysp=vpa(ysp);
ysp=subs(ysp,t);
ysp=double(ysp);

%P
figure(1);plot(t,y1,t,ysp,'--');axis([0 200  0 550]);xlabel('time,sec');ylabel('y(t) P')
figure(2);plot(t,u1);axis([0 150  0 550]);xlabel('time,sec');ylabel('u(t) P')
figure(3);plot(t,e1);axis([0 150  -100 100]);xlabel('time,sec');ylabel('e(t) P')

%PI
figure(4);plot(t,y2,'g',t,ysp,'--');axis([0 200  0 550]);xlabel('time,sec');ylabel('y(t) PI')
figure(5);plot(t,u2,'g');axis([0 150  0 550]);xlabel('time,sec');ylabel('u(t) PI')
figure(6);plot(t,e2,'g');axis([0 150  -100 100]);xlabel('time,sec');ylabel('e(t) PI')

%PID
figure(7);plot(t,y3,'r',t,ysp,'--');axis([0 200 0 550]);xlabel('time,sec');ylabel('y(t) PID')
figure(8);plot(t,u3,'r');axis([0 150  0 550]);xlabel('time,sec');ylabel('u(t) PID')
figure(9);plot(t,e3,'r');axis([0 150  -100 100]);xlabel('time,sec');ylabel('e(t) PID')

figure(10);plot(t,y1,t,y2,'g',t,y3,'r',t,ysp,'--');axis([0 200 0 550]);xlabel('time,sec');ylabel('y(t) All Controllers')